/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.mapui;

import filenet.vw.api.VWMapDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.mapui.VWDesignerWorkflowPane;
import filenet.vw.toolkit.design.property.images.VWImageLoader;
import filenet.vw.toolkit.utils.mapui.VWMap;
import filenet.vw.toolkit.utils.mapui.VWMapCache;
import filenet.vw.toolkit.utils.mapui.VWMapNameUtil;
import javax.swing.ImageIcon;

public class VWDesignerMapNameUtil
extends VWMapNameUtil {
    private static final int MAP_UNKNOWN = 0;
    private static final int MAP_LOCAL = 1;
    private static final int MAP_SYSTEM = 2;
    private static final int MAP_OVERRIDDEN = 3;
    private static final ImageIcon ICON_LOCAL_MAP = VWImageLoader.createImageIcon("blank.gif");
    private static final ImageIcon ICON_SYSTEM_MAP = VWImageLoader.createImageIcon("inherited.gif");
    private static final ImageIcon ICON_OVERRIDDEN_MAP = VWImageLoader.createImageIcon("overridden.gif");

    public VWDesignerMapNameUtil(VWMapCache mapCache) {
        super(mapCache);
    }

    public ImageIcon getMapIcon(String mapName) {
        switch (this.checkMapName(mapName)) {
            case 0: 
            case 1: {
                return ICON_LOCAL_MAP;
            }
            case 2: {
                return ICON_SYSTEM_MAP;
            }
            case 3: {
                return ICON_OVERRIDDEN_MAP;
            }
        }
        return null;
    }

    public ImageIcon getMapIcon(VWMap map) {
        if (map != null) {
            return this.getMapIcon(map.getName());
        }
        return null;
    }

    public ImageIcon getMapIcon(VWMapDefinition mapDef) {
        if (mapDef != null) {
            return this.getMapIcon(mapDef.getName());
        }
        return null;
    }

    private int checkMapName(String name) {
        int nMapType = 1;
        try {
            if (this.m_mapCache != null) {
                nMapType = this.m_mapCache.isMapExist(name, false) ? (VWDesignerWorkflowPane.isSystemMap(name) || this.m_mapCache.isBaseMapExist(name) ? 3 : 1) : (VWDesignerWorkflowPane.isSystemMap(name) || this.m_mapCache.isBaseMapExist(name) ? 2 : 0);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return nMapType;
    }
}

